package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StatefulSetCondition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatefulSetConditionAssert<S extends AbstractStatefulSetConditionAssert<S, A>, A extends StatefulSetCondition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatefulSetConditionAssert}</code> to make assertions on actual StatefulSetCondition.
   * @param actual the StatefulSetCondition we want to make assertions on.
   */
  protected AbstractStatefulSetConditionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property lastTransitionTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastTransitionTime()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastTransitionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTransitionTime"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert status()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual StatefulSetCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
