package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RollingUpdateDeployment} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRollingUpdateDeploymentAssert<S extends AbstractRollingUpdateDeploymentAssert<S, A>, A extends RollingUpdateDeployment> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRollingUpdateDeploymentAssert}</code> to make assertions on actual RollingUpdateDeployment.
   * @param actual the RollingUpdateDeployment we want to make assertions on.
   */
  protected AbstractRollingUpdateDeploymentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RollingUpdateDeployment we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property maxSurge so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert maxSurge()  {
    // check that actual RollingUpdateDeployment we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getMaxSurge()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "maxSurge"));
  }


  /**
   * Navigates to the property maxUnavailable so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert maxUnavailable()  {
    // check that actual RollingUpdateDeployment we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getMaxUnavailable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "maxUnavailable"));
  }


}
