package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentStrategyAssert<S extends AbstractDeploymentStrategyAssert<S, A>, A extends DeploymentStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentStrategyAssert}</code> to make assertions on actual DeploymentStrategy.
   * @param actual the DeploymentStrategy we want to make assertions on.
   */
  protected AbstractDeploymentStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property rollingUpdate so that assertions can be done on it
   */
  public RollingUpdateDeploymentAssert rollingUpdate()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollingUpdateDeploymentAssert) assertThat(actual.getRollingUpdate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollingUpdate"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
