package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ControllerRevision} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractControllerRevisionAssert<S extends AbstractControllerRevisionAssert<S, A>, A extends ControllerRevision> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractControllerRevisionAssert}</code> to make assertions on actual ControllerRevision.
   * @param actual the ControllerRevision we want to make assertions on.
   */
  protected AbstractControllerRevisionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property data so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert data()  {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "data"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Verifies that the actual ControllerRevision's revision is equal to the given one.
   * @param revision the given revision to compare the actual ControllerRevision's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerRevision's revision is not equal to the given one.
   */
  public S hasRevision(Long revision) {
    // check that actual ControllerRevision we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
