package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link WebhookClientConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWebhookClientConfigAssert<S extends AbstractWebhookClientConfigAssert<S, A>, A extends WebhookClientConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWebhookClientConfigAssert}</code> to make assertions on actual WebhookClientConfig.
   * @param actual the WebhookClientConfig we want to make assertions on.
   */
  protected AbstractWebhookClientConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual WebhookClientConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property caBundle so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert caBundle()  {
    // check that actual WebhookClientConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCaBundle()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "caBundle"));
  }


  /**
   * Navigates to the property service so that assertions can be done on it
   */
  public ServiceReferenceAssert service()  {
    // check that actual WebhookClientConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceReferenceAssert) assertThat(actual.getService()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "service"));
  }


  /**
   * Navigates to the property url so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert url()  {
    // check that actual WebhookClientConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUrl()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "url"));
  }


}
