package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link JSONSchemaPropsOrStringArray} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJSONSchemaPropsOrStringArrayAssert<S extends AbstractJSONSchemaPropsOrStringArrayAssert<S, A>, A extends JSONSchemaPropsOrStringArray> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJSONSchemaPropsOrStringArrayAssert}</code> to make assertions on actual JSONSchemaPropsOrStringArray.
   * @param actual the JSONSchemaPropsOrStringArray we want to make assertions on.
   */
  protected AbstractJSONSchemaPropsOrStringArrayAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JSONSchemaPropsOrStringArray we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property property so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> property()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getProperty(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "property"));
    return answer;
  }


  /**
   * Navigates to the property schema so that assertions can be done on it
   */
  public JSONSchemaPropsAssert schema()  {
    // check that actual JSONSchemaPropsOrStringArray we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JSONSchemaPropsAssert) assertThat(actual.getSchema()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schema"));
  }


}
