package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link JSONSchemaPropsOrBool} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJSONSchemaPropsOrBoolAssert<S extends AbstractJSONSchemaPropsOrBoolAssert<S, A>, A extends JSONSchemaPropsOrBool> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJSONSchemaPropsOrBoolAssert}</code> to make assertions on actual JSONSchemaPropsOrBool.
   * @param actual the JSONSchemaPropsOrBool we want to make assertions on.
   */
  protected AbstractJSONSchemaPropsOrBoolAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JSONSchemaPropsOrBool we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allows so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allows()  {
    // check that actual JSONSchemaPropsOrBool we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllows()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allows"));
  }


  /**
   * Navigates to the property schema so that assertions can be done on it
   */
  public JSONSchemaPropsAssert schema()  {
    // check that actual JSONSchemaPropsOrBool we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JSONSchemaPropsAssert) assertThat(actual.getSchema()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schema"));
  }


}
