package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link JSONSchemaPropsOrArray} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJSONSchemaPropsOrArrayAssert<S extends AbstractJSONSchemaPropsOrArrayAssert<S, A>, A extends JSONSchemaPropsOrArray> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJSONSchemaPropsOrArrayAssert}</code> to make assertions on actual JSONSchemaPropsOrArray.
   * @param actual the JSONSchemaPropsOrArray we want to make assertions on.
   */
  protected AbstractJSONSchemaPropsOrArrayAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JSONSchemaPropsOrArray we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property jSONSchemas so that assertions can be done on it
   */
  public NavigationListAssert<JSONSchemaProps, JSONSchemaPropsAssert> jSONSchemas()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<JSONSchemaProps, JSONSchemaPropsAssert> assertFactory = new AssertFactory<JSONSchemaProps, JSONSchemaPropsAssert>() {
      public JSONSchemaPropsAssert createAssert(JSONSchemaProps t) {
        return (JSONSchemaPropsAssert) assertThat(t);
      }
    };
    NavigationListAssert<JSONSchemaProps, JSONSchemaPropsAssert> answer = new NavigationListAssert<JSONSchemaProps, JSONSchemaPropsAssert>(actual.getJSONSchemas(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jSONSchemas"));
    return answer;
  }


  /**
   * Navigates to the property schema so that assertions can be done on it
   */
  public JSONSchemaPropsAssert schema()  {
    // check that actual JSONSchemaPropsOrArray we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JSONSchemaPropsAssert) assertThat(actual.getSchema()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schema"));
  }


}
