package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link JSON} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJSONAssert<S extends AbstractJSONAssert<S, A>, A extends JSON> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJSONAssert}</code> to make assertions on actual JSON.
   * @param actual the JSON we want to make assertions on.
   */
  protected AbstractJSONAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JSON we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property raw so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert raw()  {
    // check that actual JSON we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRaw()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "raw"));
  }


}
