package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceValidation} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceValidationAssert<S extends AbstractCustomResourceValidationAssert<S, A>, A extends CustomResourceValidation> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceValidationAssert}</code> to make assertions on actual CustomResourceValidation.
   * @param actual the CustomResourceValidation we want to make assertions on.
   */
  protected AbstractCustomResourceValidationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceValidation we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property openAPIV3Schema so that assertions can be done on it
   */
  public JSONSchemaPropsAssert openAPIV3Schema()  {
    // check that actual CustomResourceValidation we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JSONSchemaPropsAssert) assertThat(actual.getOpenAPIV3Schema()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openAPIV3Schema"));
  }


}
