package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceSubresources} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceSubresourcesAssert<S extends AbstractCustomResourceSubresourcesAssert<S, A>, A extends CustomResourceSubresources> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceSubresourcesAssert}</code> to make assertions on actual CustomResourceSubresources.
   * @param actual the CustomResourceSubresources we want to make assertions on.
   */
  protected AbstractCustomResourceSubresourcesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceSubresources we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property scale so that assertions can be done on it
   */
  public CustomResourceSubresourceScaleAssert scale()  {
    // check that actual CustomResourceSubresources we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceSubresourceScaleAssert) assertThat(actual.getScale()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scale"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public CustomResourceSubresourceStatusAssert status()  {
    // check that actual CustomResourceSubresources we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceSubresourceStatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


}
