package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceSubresourceScale} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceSubresourceScaleAssert<S extends AbstractCustomResourceSubresourceScaleAssert<S, A>, A extends CustomResourceSubresourceScale> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceSubresourceScaleAssert}</code> to make assertions on actual CustomResourceSubresourceScale.
   * @param actual the CustomResourceSubresourceScale we want to make assertions on.
   */
  protected AbstractCustomResourceSubresourceScaleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceSubresourceScale we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property labelSelectorPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert labelSelectorPath()  {
    // check that actual CustomResourceSubresourceScale we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLabelSelectorPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labelSelectorPath"));
  }


  /**
   * Navigates to the property specReplicasPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert specReplicasPath()  {
    // check that actual CustomResourceSubresourceScale we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSpecReplicasPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "specReplicasPath"));
  }


  /**
   * Navigates to the property statusReplicasPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert statusReplicasPath()  {
    // check that actual CustomResourceSubresourceScale we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatusReplicasPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "statusReplicasPath"));
  }


}
