package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceDefinitionVersion} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceDefinitionVersionAssert<S extends AbstractCustomResourceDefinitionVersionAssert<S, A>, A extends CustomResourceDefinitionVersion> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceDefinitionVersionAssert}</code> to make assertions on actual CustomResourceDefinitionVersion.
   * @param actual the CustomResourceDefinitionVersion we want to make assertions on.
   */
  protected AbstractCustomResourceDefinitionVersionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalPrinterColumns so that assertions can be done on it
   */
  public NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> additionalPrinterColumns()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> assertFactory = new AssertFactory<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert>() {
      public CustomResourceColumnDefinitionAssert createAssert(CustomResourceColumnDefinition t) {
        return (CustomResourceColumnDefinitionAssert) assertThat(t);
      }
    };
    NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> answer = new NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert>(actual.getAdditionalPrinterColumns(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalPrinterColumns"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property schema so that assertions can be done on it
   */
  public CustomResourceValidationAssert schema()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceValidationAssert) assertThat(actual.getSchema()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schema"));
  }


  /**
   * Navigates to the property served so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert served()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getServed()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "served"));
  }


  /**
   * Navigates to the property storage so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert storage()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getStorage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storage"));
  }


  /**
   * Navigates to the property subresources so that assertions can be done on it
   */
  public CustomResourceSubresourcesAssert subresources()  {
    // check that actual CustomResourceDefinitionVersion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceSubresourcesAssert) assertThat(actual.getSubresources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subresources"));
  }


}
