package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceDefinitionStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceDefinitionStatusAssert<S extends AbstractCustomResourceDefinitionStatusAssert<S, A>, A extends CustomResourceDefinitionStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceDefinitionStatusAssert}</code> to make assertions on actual CustomResourceDefinitionStatus.
   * @param actual the CustomResourceDefinitionStatus we want to make assertions on.
   */
  protected AbstractCustomResourceDefinitionStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property acceptedNames so that assertions can be done on it
   */
  public CustomResourceDefinitionNamesAssert acceptedNames()  {
    // check that actual CustomResourceDefinitionStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceDefinitionNamesAssert) assertThat(actual.getAcceptedNames()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "acceptedNames"));
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceDefinitionStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<CustomResourceDefinitionCondition, CustomResourceDefinitionConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CustomResourceDefinitionCondition, CustomResourceDefinitionConditionAssert> assertFactory = new AssertFactory<CustomResourceDefinitionCondition, CustomResourceDefinitionConditionAssert>() {
      public CustomResourceDefinitionConditionAssert createAssert(CustomResourceDefinitionCondition t) {
        return (CustomResourceDefinitionConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<CustomResourceDefinitionCondition, CustomResourceDefinitionConditionAssert> answer = new NavigationListAssert<CustomResourceDefinitionCondition, CustomResourceDefinitionConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property storedVersions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> storedVersions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getStoredVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storedVersions"));
    return answer;
  }


}
