package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceDefinitionSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceDefinitionSpecAssert<S extends AbstractCustomResourceDefinitionSpecAssert<S, A>, A extends CustomResourceDefinitionSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceDefinitionSpecAssert}</code> to make assertions on actual CustomResourceDefinitionSpec.
   * @param actual the CustomResourceDefinitionSpec we want to make assertions on.
   */
  protected AbstractCustomResourceDefinitionSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalPrinterColumns so that assertions can be done on it
   */
  public NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> additionalPrinterColumns()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> assertFactory = new AssertFactory<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert>() {
      public CustomResourceColumnDefinitionAssert createAssert(CustomResourceColumnDefinition t) {
        return (CustomResourceColumnDefinitionAssert) assertThat(t);
      }
    };
    NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert> answer = new NavigationListAssert<CustomResourceColumnDefinition, CustomResourceColumnDefinitionAssert>(actual.getAdditionalPrinterColumns(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalPrinterColumns"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conversion so that assertions can be done on it
   */
  public CustomResourceConversionAssert conversion()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceConversionAssert) assertThat(actual.getConversion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conversion"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property names so that assertions can be done on it
   */
  public CustomResourceDefinitionNamesAssert names()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceDefinitionNamesAssert) assertThat(actual.getNames()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "names"));
  }


  /**
   * Navigates to the property preserveUnknownFields so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert preserveUnknownFields()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPreserveUnknownFields()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preserveUnknownFields"));
  }


  /**
   * Navigates to the property scope so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert scope()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScope()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scope"));
  }


  /**
   * Navigates to the property subresources so that assertions can be done on it
   */
  public CustomResourceSubresourcesAssert subresources()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceSubresourcesAssert) assertThat(actual.getSubresources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subresources"));
  }


  /**
   * Navigates to the property validation so that assertions can be done on it
   */
  public CustomResourceValidationAssert validation()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceValidationAssert) assertThat(actual.getValidation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "validation"));
  }


  /**
   * Navigates to the property version so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert version()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "version"));
  }


  /**
   * Navigates to the property versions so that assertions can be done on it
   */
  public NavigationListAssert<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionAssert> versions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionAssert> assertFactory = new AssertFactory<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionAssert>() {
      public CustomResourceDefinitionVersionAssert createAssert(CustomResourceDefinitionVersion t) {
        return (CustomResourceDefinitionVersionAssert) assertThat(t);
      }
    };
    NavigationListAssert<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionAssert> answer = new NavigationListAssert<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionAssert>(actual.getVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "versions"));
    return answer;
  }


}
