package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceConversion} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceConversionAssert<S extends AbstractCustomResourceConversionAssert<S, A>, A extends CustomResourceConversion> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceConversionAssert}</code> to make assertions on actual CustomResourceConversion.
   * @param actual the CustomResourceConversion we want to make assertions on.
   */
  protected AbstractCustomResourceConversionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceConversion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conversionReviewVersions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> conversionReviewVersions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getConversionReviewVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conversionReviewVersions"));
    return answer;
  }


  /**
   * Navigates to the property strategy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert strategy()  {
    // check that actual CustomResourceConversion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"));
  }


  /**
   * Navigates to the property webhookClientConfig so that assertions can be done on it
   */
  public WebhookClientConfigAssert webhookClientConfig()  {
    // check that actual CustomResourceConversion we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WebhookClientConfigAssert) assertThat(actual.getWebhookClientConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "webhookClientConfig"));
  }


}
