package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceColumnDefinition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceColumnDefinitionAssert<S extends AbstractCustomResourceColumnDefinitionAssert<S, A>, A extends CustomResourceColumnDefinition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceColumnDefinitionAssert}</code> to make assertions on actual CustomResourceColumnDefinition.
   * @param actual the CustomResourceColumnDefinition we want to make assertions on.
   */
  protected AbstractCustomResourceColumnDefinitionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property description so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert description()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDescription()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "description"));
  }


  /**
   * Navigates to the property format so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert format()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFormat()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "format"));
  }


  /**
   * Navigates to the property jSONPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert jSONPath()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getJSONPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jSONPath"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Verifies that the actual CustomResourceColumnDefinition's priority is equal to the given one.
   * @param priority the given priority to compare the actual CustomResourceColumnDefinition's priority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomResourceColumnDefinition's priority is not equal to the given one.
   */
  public S hasPriority(Integer priority) {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPriority = actual.getPriority();
    if (!Objects.areEqual(actualPriority, priority)) {
      failWithMessage(assertjErrorMessage, actual, priority, actualPriority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual CustomResourceColumnDefinition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
