package io.fabric8.kubernetes.api.model.admissionregistration;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ValidatingWebhook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractValidatingWebhookAssert<S extends AbstractValidatingWebhookAssert<S, A>, A extends ValidatingWebhook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractValidatingWebhookAssert}</code> to make assertions on actual ValidatingWebhook.
   * @param actual the ValidatingWebhook we want to make assertions on.
   */
  protected AbstractValidatingWebhookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property admissionReviewVersions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> admissionReviewVersions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAdmissionReviewVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "admissionReviewVersions"));
    return answer;
  }


  /**
   * Navigates to the property clientConfig so that assertions can be done on it
   */
  public WebhookClientConfigAssert clientConfig()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WebhookClientConfigAssert) assertThat(actual.getClientConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientConfig"));
  }


  /**
   * Navigates to the property failurePolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert failurePolicy()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFailurePolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "failurePolicy"));
  }


  /**
   * Navigates to the property matchPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert matchPolicy()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMatchPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchPolicy"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property namespaceSelector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert namespaceSelector()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getNamespaceSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaceSelector"));
  }


  /**
   * Navigates to the property objectSelector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert objectSelector()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getObjectSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "objectSelector"));
  }


  /**
   * Navigates to the property rules so that assertions can be done on it
   */
  public NavigationListAssert<RuleWithOperations, RuleWithOperationsAssert> rules()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<RuleWithOperations, RuleWithOperationsAssert> assertFactory = new AssertFactory<RuleWithOperations, RuleWithOperationsAssert>() {
      public RuleWithOperationsAssert createAssert(RuleWithOperations t) {
        return (RuleWithOperationsAssert) assertThat(t);
      }
    };
    NavigationListAssert<RuleWithOperations, RuleWithOperationsAssert> answer = new NavigationListAssert<RuleWithOperations, RuleWithOperationsAssert>(actual.getRules(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rules"));
    return answer;
  }


  /**
   * Navigates to the property sideEffects so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert sideEffects()  {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSideEffects()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sideEffects"));
  }


  /**
   * Verifies that the actual ValidatingWebhook's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual ValidatingWebhook's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ValidatingWebhook's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Integer timeoutSeconds) {
    // check that actual ValidatingWebhook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
