package io.fabric8.kubernetes.api.model.admissionregistration;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Rule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRuleAssert<S extends AbstractRuleAssert<S, A>, A extends Rule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRuleAssert}</code> to make assertions on actual Rule.
   * @param actual the Rule we want to make assertions on.
   */
  protected AbstractRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Rule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiGroups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> apiGroups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getApiGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiGroups"));
    return answer;
  }


  /**
   * Navigates to the property apiVersions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> apiVersions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getApiVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersions"));
    return answer;
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> resources()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getResources(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
    return answer;
  }


  /**
   * Navigates to the property scope so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert scope()  {
    // check that actual Rule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScope()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scope"));
  }


}
