package io.fabric8.kubernetes.api.model.admissionregistration;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link MutatingWebhookConfiguration} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMutatingWebhookConfigurationAssert<S extends AbstractMutatingWebhookConfigurationAssert<S, A>, A extends MutatingWebhookConfiguration> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMutatingWebhookConfigurationAssert}</code> to make assertions on actual MutatingWebhookConfiguration.
   * @param actual the MutatingWebhookConfiguration we want to make assertions on.
   */
  protected AbstractMutatingWebhookConfigurationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual MutatingWebhookConfiguration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual MutatingWebhookConfiguration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual MutatingWebhookConfiguration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual MutatingWebhookConfiguration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property webhooks so that assertions can be done on it
   */
  public NavigationListAssert<MutatingWebhook, MutatingWebhookAssert> webhooks()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<MutatingWebhook, MutatingWebhookAssert> assertFactory = new AssertFactory<MutatingWebhook, MutatingWebhookAssert>() {
      public MutatingWebhookAssert createAssert(MutatingWebhook t) {
        return (MutatingWebhookAssert) assertThat(t);
      }
    };
    NavigationListAssert<MutatingWebhook, MutatingWebhookAssert> answer = new NavigationListAssert<MutatingWebhook, MutatingWebhookAssert>(actual.getWebhooks(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "webhooks"));
    return answer;
  }


}
