package io.fabric8.kubernetes.api.model.admission;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AdmissionResponse} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAdmissionResponseAssert<S extends AbstractAdmissionResponseAssert<S, A>, A extends AdmissionResponse> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAdmissionResponseAssert}</code> to make assertions on actual AdmissionResponse.
   * @param actual the AdmissionResponse we want to make assertions on.
   */
  protected AbstractAdmissionResponseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowed so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowed()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowed()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowed"));
  }


  /**
   * Navigates to the property auditAnnotations so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert auditAnnotations()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAuditAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "auditAnnotations"));
  }


  /**
   * Navigates to the property patch so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert patch()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPatch()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patch"));
  }


  /**
   * Navigates to the property patchType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert patchType()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPatchType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patchType"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.StatusAssert status()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.StatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual AdmissionResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
