package io.fabric8.kubernetes.api.model.admission;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AdmissionRequest} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAdmissionRequestAssert<S extends AbstractAdmissionRequestAssert<S, A>, A extends AdmissionRequest> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAdmissionRequestAssert}</code> to make assertions on actual AdmissionRequest.
   * @param actual the AdmissionRequest we want to make assertions on.
   */
  protected AbstractAdmissionRequestAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property dryRun so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert dryRun()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getDryRun()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dryRun"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.GroupVersionKindAssert kind()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.GroupVersionKindAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property object so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert object()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "object"));
  }


  /**
   * Navigates to the property oldObject so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert oldObject()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getOldObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oldObject"));
  }


  /**
   * Navigates to the property operation so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operation()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operation"));
  }


  /**
   * Navigates to the property options so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert options()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "options"));
  }


  /**
   * Navigates to the property requestKind so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.GroupVersionKindAssert requestKind()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.GroupVersionKindAssert) assertThat(actual.getRequestKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requestKind"));
  }


  /**
   * Navigates to the property requestResource so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.GroupVersionResourceAssert requestResource()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.GroupVersionResourceAssert) assertThat(actual.getRequestResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requestResource"));
  }


  /**
   * Navigates to the property requestSubResource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert requestSubResource()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRequestSubResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requestSubResource"));
  }


  /**
   * Navigates to the property resource so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.GroupVersionResourceAssert resource()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.GroupVersionResourceAssert) assertThat(actual.getResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resource"));
  }


  /**
   * Navigates to the property subResource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert subResource()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSubResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subResource"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


  /**
   * Navigates to the property userInfo so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.authentication.UserInfoAssert userInfo()  {
    // check that actual AdmissionRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.authentication.UserInfoAssert) assertThat(actual.getUserInfo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userInfo"));
  }


}
