package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link WindowsSecurityContextOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWindowsSecurityContextOptionsAssert<S extends AbstractWindowsSecurityContextOptionsAssert<S, A>, A extends WindowsSecurityContextOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWindowsSecurityContextOptionsAssert}</code> to make assertions on actual WindowsSecurityContextOptions.
   * @param actual the WindowsSecurityContextOptions we want to make assertions on.
   */
  protected AbstractWindowsSecurityContextOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual WindowsSecurityContextOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property gmsaCredentialSpec so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gmsaCredentialSpec()  {
    // check that actual WindowsSecurityContextOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGmsaCredentialSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gmsaCredentialSpec"));
  }


  /**
   * Navigates to the property gmsaCredentialSpecName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gmsaCredentialSpecName()  {
    // check that actual WindowsSecurityContextOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGmsaCredentialSpecName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gmsaCredentialSpecName"));
  }


  /**
   * Navigates to the property runAsUserName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert runAsUserName()  {
    // check that actual WindowsSecurityContextOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRunAsUserName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsUserName"));
  }


}
