package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeProjection} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeProjectionAssert<S extends AbstractVolumeProjectionAssert<S, A>, A extends VolumeProjection> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeProjectionAssert}</code> to make assertions on actual VolumeProjection.
   * @param actual the VolumeProjection we want to make assertions on.
   */
  protected AbstractVolumeProjectionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public ConfigMapProjectionAssert configMap()  {
    // check that actual VolumeProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapProjectionAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


  /**
   * Navigates to the property downwardAPI so that assertions can be done on it
   */
  public DownwardAPIProjectionAssert downwardAPI()  {
    // check that actual VolumeProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DownwardAPIProjectionAssert) assertThat(actual.getDownwardAPI()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "downwardAPI"));
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public SecretProjectionAssert secret()  {
    // check that actual VolumeProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretProjectionAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


  /**
   * Navigates to the property serviceAccountToken so that assertions can be done on it
   */
  public ServiceAccountTokenProjectionAssert serviceAccountToken()  {
    // check that actual VolumeProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountTokenProjectionAssert) assertThat(actual.getServiceAccountToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountToken"));
  }


}
