package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeNodeAffinity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeNodeAffinityAssert<S extends AbstractVolumeNodeAffinityAssert<S, A>, A extends VolumeNodeAffinity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeNodeAffinityAssert}</code> to make assertions on actual VolumeNodeAffinity.
   * @param actual the VolumeNodeAffinity we want to make assertions on.
   */
  protected AbstractVolumeNodeAffinityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeNodeAffinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property required so that assertions can be done on it
   */
  public NodeSelectorAssert required()  {
    // check that actual VolumeNodeAffinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeSelectorAssert) assertThat(actual.getRequired()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "required"));
  }


}
