package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TypedLocalObjectReference} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTypedLocalObjectReferenceAssert<S extends AbstractTypedLocalObjectReferenceAssert<S, A>, A extends TypedLocalObjectReference> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypedLocalObjectReferenceAssert}</code> to make assertions on actual TypedLocalObjectReference.
   * @param actual the TypedLocalObjectReference we want to make assertions on.
   */
  protected AbstractTypedLocalObjectReferenceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TypedLocalObjectReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiGroup so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiGroup()  {
    // check that actual TypedLocalObjectReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiGroup"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual TypedLocalObjectReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual TypedLocalObjectReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


}
