package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TopologySpreadConstraint} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTopologySpreadConstraintAssert<S extends AbstractTopologySpreadConstraintAssert<S, A>, A extends TopologySpreadConstraint> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTopologySpreadConstraintAssert}</code> to make assertions on actual TopologySpreadConstraint.
   * @param actual the TopologySpreadConstraint we want to make assertions on.
   */
  protected AbstractTopologySpreadConstraintAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TopologySpreadConstraint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property labelSelector so that assertions can be done on it
   */
  public LabelSelectorAssert labelSelector()  {
    // check that actual TopologySpreadConstraint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LabelSelectorAssert) assertThat(actual.getLabelSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labelSelector"));
  }


  /**
   * Verifies that the actual TopologySpreadConstraint's maxSkew is equal to the given one.
   * @param maxSkew the given maxSkew to compare the actual TopologySpreadConstraint's maxSkew to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TopologySpreadConstraint's maxSkew is not equal to the given one.
   */
  public S hasMaxSkew(Integer maxSkew) {
    // check that actual TopologySpreadConstraint we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxSkew of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMaxSkew = actual.getMaxSkew();
    if (!Objects.areEqual(actualMaxSkew, maxSkew)) {
      failWithMessage(assertjErrorMessage, actual, maxSkew, actualMaxSkew);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property topologyKey so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert topologyKey()  {
    // check that actual TopologySpreadConstraint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTopologyKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologyKey"));
  }


  /**
   * Navigates to the property whenUnsatisfiable so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert whenUnsatisfiable()  {
    // check that actual TopologySpreadConstraint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getWhenUnsatisfiable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "whenUnsatisfiable"));
  }


}
