package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TopologySelectorTerm} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTopologySelectorTermAssert<S extends AbstractTopologySelectorTermAssert<S, A>, A extends TopologySelectorTerm> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTopologySelectorTermAssert}</code> to make assertions on actual TopologySelectorTerm.
   * @param actual the TopologySelectorTerm we want to make assertions on.
   */
  protected AbstractTopologySelectorTermAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TopologySelectorTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property matchLabelExpressions so that assertions can be done on it
   */
  public NavigationListAssert<TopologySelectorLabelRequirement, TopologySelectorLabelRequirementAssert> matchLabelExpressions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TopologySelectorLabelRequirement, TopologySelectorLabelRequirementAssert> assertFactory = new AssertFactory<TopologySelectorLabelRequirement, TopologySelectorLabelRequirementAssert>() {
      public TopologySelectorLabelRequirementAssert createAssert(TopologySelectorLabelRequirement t) {
        return (TopologySelectorLabelRequirementAssert) assertThat(t);
      }
    };
    NavigationListAssert<TopologySelectorLabelRequirement, TopologySelectorLabelRequirementAssert> answer = new NavigationListAssert<TopologySelectorLabelRequirement, TopologySelectorLabelRequirementAssert>(actual.getMatchLabelExpressions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchLabelExpressions"));
    return answer;
  }


}
