package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TCPSocketAction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTCPSocketActionAssert<S extends AbstractTCPSocketActionAssert<S, A>, A extends TCPSocketAction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTCPSocketActionAssert}</code> to make assertions on actual TCPSocketAction.
   * @param actual the TCPSocketAction we want to make assertions on.
   */
  protected AbstractTCPSocketActionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TCPSocketAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual TCPSocketAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


  /**
   * Navigates to the property port so that assertions can be done on it
   */
  public IntOrStringAssert port()  {
    // check that actual TCPSocketAction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (IntOrStringAssert) assertThat(actual.getPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "port"));
  }


}
