package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StorageOSVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStorageOSVolumeSourceAssert<S extends AbstractStorageOSVolumeSourceAssert<S, A>, A extends StorageOSVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStorageOSVolumeSourceAssert}</code> to make assertions on actual StorageOSVolumeSource.
   * @param actual the StorageOSVolumeSource we want to make assertions on.
   */
  protected AbstractStorageOSVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public LocalObjectReferenceAssert secretRef()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalObjectReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property volumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeName()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeName"));
  }


  /**
   * Navigates to the property volumeNamespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeNamespace()  {
    // check that actual StorageOSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeNamespace"));
  }


}
