package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StorageOSPersistentVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStorageOSPersistentVolumeSourceAssert<S extends AbstractStorageOSPersistentVolumeSourceAssert<S, A>, A extends StorageOSPersistentVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStorageOSPersistentVolumeSourceAssert}</code> to make assertions on actual StorageOSPersistentVolumeSource.
   * @param actual the StorageOSPersistentVolumeSource we want to make assertions on.
   */
  protected AbstractStorageOSPersistentVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public ObjectReferenceAssert secretRef()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property volumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeName()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeName"));
  }


  /**
   * Navigates to the property volumeNamespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeNamespace()  {
    // check that actual StorageOSPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeNamespace"));
  }


}
