package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StatusDetails} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusDetailsAssert<S extends AbstractStatusDetailsAssert<S, A>, A extends StatusDetails> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusDetailsAssert}</code> to make assertions on actual StatusDetails.
   * @param actual the StatusDetails we want to make assertions on.
   */
  protected AbstractStatusDetailsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property causes so that assertions can be done on it
   */
  public NavigationListAssert<StatusCause, StatusCauseAssert> causes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<StatusCause, StatusCauseAssert> assertFactory = new AssertFactory<StatusCause, StatusCauseAssert>() {
      public StatusCauseAssert createAssert(StatusCause t) {
        return (StatusCauseAssert) assertThat(t);
      }
    };
    NavigationListAssert<StatusCause, StatusCauseAssert> answer = new NavigationListAssert<StatusCause, StatusCauseAssert>(actual.getCauses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "causes"));
    return answer;
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Verifies that the actual StatusDetails's retryAfterSeconds is equal to the given one.
   * @param retryAfterSeconds the given retryAfterSeconds to compare the actual StatusDetails's retryAfterSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusDetails's retryAfterSeconds is not equal to the given one.
   */
  public S hasRetryAfterSeconds(Integer retryAfterSeconds) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting retryAfterSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRetryAfterSeconds = actual.getRetryAfterSeconds();
    if (!Objects.areEqual(actualRetryAfterSeconds, retryAfterSeconds)) {
      failWithMessage(assertjErrorMessage, actual, retryAfterSeconds, actualRetryAfterSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
