package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceStatusAssert<S extends AbstractServiceStatusAssert<S, A>, A extends ServiceStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceStatusAssert}</code> to make assertions on actual ServiceStatus.
   * @param actual the ServiceStatus we want to make assertions on.
   */
  protected AbstractServiceStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property loadBalancer so that assertions can be done on it
   */
  public LoadBalancerStatusAssert loadBalancer()  {
    // check that actual ServiceStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LoadBalancerStatusAssert) assertThat(actual.getLoadBalancer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancer"));
  }


}
