package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceSpecAssert<S extends AbstractServiceSpecAssert<S, A>, A extends ServiceSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceSpecAssert}</code> to make assertions on actual ServiceSpec.
   * @param actual the ServiceSpec we want to make assertions on.
   */
  protected AbstractServiceSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property clusterIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clusterIP()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClusterIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterIP"));
  }


  /**
   * Navigates to the property externalIPs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> externalIPs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getExternalIPs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalIPs"));
    return answer;
  }


  /**
   * Navigates to the property externalName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert externalName()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getExternalName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalName"));
  }


  /**
   * Navigates to the property externalTrafficPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert externalTrafficPolicy()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getExternalTrafficPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalTrafficPolicy"));
  }


  /**
   * Verifies that the actual ServiceSpec's healthCheckNodePort is equal to the given one.
   * @param healthCheckNodePort the given healthCheckNodePort to compare the actual ServiceSpec's healthCheckNodePort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpec's healthCheckNodePort is not equal to the given one.
   */
  public S hasHealthCheckNodePort(Integer healthCheckNodePort) {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting healthCheckNodePort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualHealthCheckNodePort = actual.getHealthCheckNodePort();
    if (!Objects.areEqual(actualHealthCheckNodePort, healthCheckNodePort)) {
      failWithMessage(assertjErrorMessage, actual, healthCheckNodePort, actualHealthCheckNodePort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property ipFamily so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert ipFamily()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getIpFamily()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ipFamily"));
  }


  /**
   * Navigates to the property loadBalancerIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert loadBalancerIP()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLoadBalancerIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerIP"));
  }


  /**
   * Navigates to the property loadBalancerSourceRanges so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> loadBalancerSourceRanges()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getLoadBalancerSourceRanges(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerSourceRanges"));
    return answer;
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<ServicePort, ServicePortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ServicePort, ServicePortAssert> assertFactory = new AssertFactory<ServicePort, ServicePortAssert>() {
      public ServicePortAssert createAssert(ServicePort t) {
        return (ServicePortAssert) assertThat(t);
      }
    };
    NavigationListAssert<ServicePort, ServicePortAssert> answer = new NavigationListAssert<ServicePort, ServicePortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


  /**
   * Navigates to the property publishNotReadyAddresses so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert publishNotReadyAddresses()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPublishNotReadyAddresses()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "publishNotReadyAddresses"));
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert selector()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property sessionAffinity so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert sessionAffinity()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSessionAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sessionAffinity"));
  }


  /**
   * Navigates to the property sessionAffinityConfig so that assertions can be done on it
   */
  public SessionAffinityConfigAssert sessionAffinityConfig()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SessionAffinityConfigAssert) assertThat(actual.getSessionAffinityConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sessionAffinityConfig"));
  }


  /**
   * Navigates to the property topologyKeys so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> topologyKeys()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getTopologyKeys(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologyKeys"));
    return answer;
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
