package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceAccountTokenProjection} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAccountTokenProjectionAssert<S extends AbstractServiceAccountTokenProjectionAssert<S, A>, A extends ServiceAccountTokenProjection> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAccountTokenProjectionAssert}</code> to make assertions on actual ServiceAccountTokenProjection.
   * @param actual the ServiceAccountTokenProjection we want to make assertions on.
   */
  protected AbstractServiceAccountTokenProjectionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceAccountTokenProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property audience so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert audience()  {
    // check that actual ServiceAccountTokenProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAudience()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "audience"));
  }


  /**
   * Verifies that the actual ServiceAccountTokenProjection's expirationSeconds is equal to the given one.
   * @param expirationSeconds the given expirationSeconds to compare the actual ServiceAccountTokenProjection's expirationSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccountTokenProjection's expirationSeconds is not equal to the given one.
   */
  public S hasExpirationSeconds(Long expirationSeconds) {
    // check that actual ServiceAccountTokenProjection we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting expirationSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualExpirationSeconds = actual.getExpirationSeconds();
    if (!Objects.areEqual(actualExpirationSeconds, expirationSeconds)) {
      failWithMessage(assertjErrorMessage, actual, expirationSeconds, actualExpirationSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual ServiceAccountTokenProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


}
