package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceAccount} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAccountAssert<S extends AbstractServiceAccountAssert<S, A>, A extends ServiceAccount> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAccountAssert}</code> to make assertions on actual ServiceAccount.
   * @param actual the ServiceAccount we want to make assertions on.
   */
  protected AbstractServiceAccountAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property automountServiceAccountToken so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert automountServiceAccountToken()  {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAutomountServiceAccountToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "automountServiceAccountToken"));
  }


  /**
   * Navigates to the property imagePullSecrets so that assertions can be done on it
   */
  public NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> imagePullSecrets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<LocalObjectReference, LocalObjectReferenceAssert> assertFactory = new AssertFactory<LocalObjectReference, LocalObjectReferenceAssert>() {
      public LocalObjectReferenceAssert createAssert(LocalObjectReference t) {
        return (LocalObjectReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> answer = new NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert>(actual.getImagePullSecrets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullSecrets"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property secrets so that assertions can be done on it
   */
  public NavigationListAssert<ObjectReference, ObjectReferenceAssert> secrets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ObjectReference, ObjectReferenceAssert> assertFactory = new AssertFactory<ObjectReference, ObjectReferenceAssert>() {
      public ObjectReferenceAssert createAssert(ObjectReference t) {
        return (ObjectReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<ObjectReference, ObjectReferenceAssert> answer = new NavigationListAssert<ObjectReference, ObjectReferenceAssert>(actual.getSecrets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secrets"));
    return answer;
  }


}
