package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ServerAddressByClientCIDR} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServerAddressByClientCIDRAssert<S extends AbstractServerAddressByClientCIDRAssert<S, A>, A extends ServerAddressByClientCIDR> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServerAddressByClientCIDRAssert}</code> to make assertions on actual ServerAddressByClientCIDR.
   * @param actual the ServerAddressByClientCIDR we want to make assertions on.
   */
  protected AbstractServerAddressByClientCIDRAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServerAddressByClientCIDR we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property clientCIDR so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientCIDR()  {
    // check that actual ServerAddressByClientCIDR we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientCIDR()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientCIDR"));
  }


  /**
   * Navigates to the property serverAddress so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serverAddress()  {
    // check that actual ServerAddressByClientCIDR we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServerAddress()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serverAddress"));
  }


}
