package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SecretVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretVolumeSourceAssert<S extends AbstractSecretVolumeSourceAssert<S, A>, A extends SecretVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretVolumeSourceAssert}</code> to make assertions on actual SecretVolumeSource.
   * @param actual the SecretVolumeSource we want to make assertions on.
   */
  protected AbstractSecretVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual SecretVolumeSource's defaultMode is equal to the given one.
   * @param defaultMode the given defaultMode to compare the actual SecretVolumeSource's defaultMode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretVolumeSource's defaultMode is not equal to the given one.
   */
  public S hasDefaultMode(Integer defaultMode) {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting defaultMode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDefaultMode = actual.getDefaultMode();
    if (!Objects.areEqual(actualDefaultMode, defaultMode)) {
      failWithMessage(assertjErrorMessage, actual, defaultMode, actualDefaultMode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<KeyToPath, KeyToPathAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<KeyToPath, KeyToPathAssert> assertFactory = new AssertFactory<KeyToPath, KeyToPathAssert>() {
      public KeyToPathAssert createAssert(KeyToPath t) {
        return (KeyToPathAssert) assertThat(t);
      }
    };
    NavigationListAssert<KeyToPath, KeyToPathAssert> answer = new NavigationListAssert<KeyToPath, KeyToPathAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property optional so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert optional()  {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getOptional()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "optional"));
  }


  /**
   * Navigates to the property secretName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert secretName()  {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSecretName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretName"));
  }


}
