package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Secret} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretAssert<S extends AbstractSecretAssert<S, A>, A extends Secret> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretAssert}</code> to make assertions on actual Secret.
   * @param actual the Secret we want to make assertions on.
   */
  protected AbstractSecretAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property data so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert data()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "data"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property stringData so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert stringData()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getStringData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stringData"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
