package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ScopedResourceSelectorRequirement} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScopedResourceSelectorRequirementAssert<S extends AbstractScopedResourceSelectorRequirementAssert<S, A>, A extends ScopedResourceSelectorRequirement> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScopedResourceSelectorRequirementAssert}</code> to make assertions on actual ScopedResourceSelectorRequirement.
   * @param actual the ScopedResourceSelectorRequirement we want to make assertions on.
   */
  protected AbstractScopedResourceSelectorRequirementAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScopedResourceSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property operator so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operator()  {
    // check that actual ScopedResourceSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperator()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operator"));
  }


  /**
   * Navigates to the property scopeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert scopeName()  {
    // check that actual ScopedResourceSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScopeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopeName"));
  }


  /**
   * Navigates to the property values so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> values()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getValues(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "values"));
    return answer;
  }


}
