package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ScopeSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScopeSelectorAssert<S extends AbstractScopeSelectorAssert<S, A>, A extends ScopeSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScopeSelectorAssert}</code> to make assertions on actual ScopeSelector.
   * @param actual the ScopeSelector we want to make assertions on.
   */
  protected AbstractScopeSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScopeSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property matchExpressions so that assertions can be done on it
   */
  public NavigationListAssert<ScopedResourceSelectorRequirement, ScopedResourceSelectorRequirementAssert> matchExpressions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ScopedResourceSelectorRequirement, ScopedResourceSelectorRequirementAssert> assertFactory = new AssertFactory<ScopedResourceSelectorRequirement, ScopedResourceSelectorRequirementAssert>() {
      public ScopedResourceSelectorRequirementAssert createAssert(ScopedResourceSelectorRequirement t) {
        return (ScopedResourceSelectorRequirementAssert) assertThat(t);
      }
    };
    NavigationListAssert<ScopedResourceSelectorRequirement, ScopedResourceSelectorRequirementAssert> answer = new NavigationListAssert<ScopedResourceSelectorRequirement, ScopedResourceSelectorRequirementAssert>(actual.getMatchExpressions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchExpressions"));
    return answer;
  }


}
