package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ScaleIOPersistentVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleIOPersistentVolumeSourceAssert<S extends AbstractScaleIOPersistentVolumeSourceAssert<S, A>, A extends ScaleIOPersistentVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleIOPersistentVolumeSourceAssert}</code> to make assertions on actual ScaleIOPersistentVolumeSource.
   * @param actual the ScaleIOPersistentVolumeSource we want to make assertions on.
   */
  protected AbstractScaleIOPersistentVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property gateway so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gateway()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGateway()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gateway"));
  }


  /**
   * Navigates to the property protectionDomain so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert protectionDomain()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProtectionDomain()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protectionDomain"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public SecretReferenceAssert secretRef()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property sslEnabled so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert sslEnabled()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getSslEnabled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sslEnabled"));
  }


  /**
   * Navigates to the property storageMode so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storageMode()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStorageMode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageMode"));
  }


  /**
   * Navigates to the property storagePool so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storagePool()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStoragePool()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storagePool"));
  }


  /**
   * Navigates to the property system so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert system()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "system"));
  }


  /**
   * Navigates to the property volumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeName()  {
    // check that actual ScaleIOPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeName"));
  }


}
