package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SELinuxOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSELinuxOptionsAssert<S extends AbstractSELinuxOptionsAssert<S, A>, A extends SELinuxOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSELinuxOptionsAssert}</code> to make assertions on actual SELinuxOptions.
   * @param actual the SELinuxOptions we want to make assertions on.
   */
  protected AbstractSELinuxOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property level so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert level()  {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLevel()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "level"));
  }


  /**
   * Navigates to the property role so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert role()  {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "role"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
