package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceQuotaStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceQuotaStatusAssert<S extends AbstractResourceQuotaStatusAssert<S, A>, A extends ResourceQuotaStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceQuotaStatusAssert}</code> to make assertions on actual ResourceQuotaStatus.
   * @param actual the ResourceQuotaStatus we want to make assertions on.
   */
  protected AbstractResourceQuotaStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceQuotaStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property hard so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert hard()  {
    // check that actual ResourceQuotaStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getHard()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hard"));
  }


  /**
   * Navigates to the property used so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert used()  {
    // check that actual ResourceQuotaStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getUsed()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "used"));
  }


}
