package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceMetricSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceMetricSourceAssert<S extends AbstractResourceMetricSourceAssert<S, A>, A extends ResourceMetricSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceMetricSourceAssert}</code> to make assertions on actual ResourceMetricSource.
   * @param actual the ResourceMetricSource we want to make assertions on.
   */
  protected AbstractResourceMetricSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ResourceMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property target so that assertions can be done on it
   */
  public MetricTargetAssert target()  {
    // check that actual ResourceMetricSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (MetricTargetAssert) assertThat(actual.getTarget()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "target"));
  }


}
