package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceFieldSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceFieldSelectorAssert<S extends AbstractResourceFieldSelectorAssert<S, A>, A extends ResourceFieldSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceFieldSelectorAssert}</code> to make assertions on actual ResourceFieldSelector.
   * @param actual the ResourceFieldSelector we want to make assertions on.
   */
  protected AbstractResourceFieldSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property containerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert containerName()  {
    // check that actual ResourceFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainerName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerName"));
  }


  /**
   * Navigates to the property divisor so that assertions can be done on it
   */
  public QuantityAssert divisor()  {
    // check that actual ResourceFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getDivisor()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "divisor"));
  }


  /**
   * Navigates to the property resource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resource()  {
    // check that actual ResourceFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resource"));
  }


}
