package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ReplicationControllerList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerListAssert<S extends AbstractReplicationControllerListAssert<S, A>, A extends ReplicationControllerList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerListAssert}</code> to make assertions on actual ReplicationControllerList.
   * @param actual the ReplicationControllerList we want to make assertions on.
   */
  protected AbstractReplicationControllerListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<ReplicationController, ReplicationControllerAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ReplicationController, ReplicationControllerAssert> assertFactory = new AssertFactory<ReplicationController, ReplicationControllerAssert>() {
      public ReplicationControllerAssert createAssert(ReplicationController t) {
        return (ReplicationControllerAssert) assertThat(t);
      }
    };
    NavigationListAssert<ReplicationController, ReplicationControllerAssert> answer = new NavigationListAssert<ReplicationController, ReplicationControllerAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ListMetaAssert metadata()  {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
