package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RBDPersistentVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRBDPersistentVolumeSourceAssert<S extends AbstractRBDPersistentVolumeSourceAssert<S, A>, A extends RBDPersistentVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRBDPersistentVolumeSourceAssert}</code> to make assertions on actual RBDPersistentVolumeSource.
   * @param actual the RBDPersistentVolumeSource we want to make assertions on.
   */
  protected AbstractRBDPersistentVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property keyring so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert keyring()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKeyring()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "keyring"));
  }


  /**
   * Navigates to the property monitors so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> monitors()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getMonitors(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "monitors"));
    return answer;
  }


  /**
   * Navigates to the property pool so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert pool()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPool()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pool"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public SecretReferenceAssert secretRef()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual RBDPersistentVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
