package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link QuobyteVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractQuobyteVolumeSourceAssert<S extends AbstractQuobyteVolumeSourceAssert<S, A>, A extends QuobyteVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractQuobyteVolumeSourceAssert}</code> to make assertions on actual QuobyteVolumeSource.
   * @param actual the QuobyteVolumeSource we want to make assertions on.
   */
  protected AbstractQuobyteVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property registry so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert registry()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRegistry()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "registry"));
  }


  /**
   * Navigates to the property tenant so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert tenant()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTenant()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tenant"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


  /**
   * Navigates to the property volume so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volume()  {
    // check that actual QuobyteVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volume"));
  }


}
