package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Probe} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProbeAssert<S extends AbstractProbeAssert<S, A>, A extends Probe> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProbeAssert}</code> to make assertions on actual Probe.
   * @param actual the Probe we want to make assertions on.
   */
  protected AbstractProbeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property exec so that assertions can be done on it
   */
  public ExecActionAssert exec()  {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ExecActionAssert) assertThat(actual.getExec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "exec"));
  }


  /**
   * Verifies that the actual Probe's failureThreshold is equal to the given one.
   * @param failureThreshold the given failureThreshold to compare the actual Probe's failureThreshold to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Probe's failureThreshold is not equal to the given one.
   */
  public S hasFailureThreshold(Integer failureThreshold) {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failureThreshold of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualFailureThreshold = actual.getFailureThreshold();
    if (!Objects.areEqual(actualFailureThreshold, failureThreshold)) {
      failWithMessage(assertjErrorMessage, actual, failureThreshold, actualFailureThreshold);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property httpGet so that assertions can be done on it
   */
  public HTTPGetActionAssert httpGet()  {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HTTPGetActionAssert) assertThat(actual.getHttpGet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "httpGet"));
  }


  /**
   * Verifies that the actual Probe's initialDelaySeconds is equal to the given one.
   * @param initialDelaySeconds the given initialDelaySeconds to compare the actual Probe's initialDelaySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Probe's initialDelaySeconds is not equal to the given one.
   */
  public S hasInitialDelaySeconds(Integer initialDelaySeconds) {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting initialDelaySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualInitialDelaySeconds = actual.getInitialDelaySeconds();
    if (!Objects.areEqual(actualInitialDelaySeconds, initialDelaySeconds)) {
      failWithMessage(assertjErrorMessage, actual, initialDelaySeconds, actualInitialDelaySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Probe's periodSeconds is equal to the given one.
   * @param periodSeconds the given periodSeconds to compare the actual Probe's periodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Probe's periodSeconds is not equal to the given one.
   */
  public S hasPeriodSeconds(Integer periodSeconds) {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting periodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPeriodSeconds = actual.getPeriodSeconds();
    if (!Objects.areEqual(actualPeriodSeconds, periodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, periodSeconds, actualPeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Probe's successThreshold is equal to the given one.
   * @param successThreshold the given successThreshold to compare the actual Probe's successThreshold to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Probe's successThreshold is not equal to the given one.
   */
  public S hasSuccessThreshold(Integer successThreshold) {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting successThreshold of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSuccessThreshold = actual.getSuccessThreshold();
    if (!Objects.areEqual(actualSuccessThreshold, successThreshold)) {
      failWithMessage(assertjErrorMessage, actual, successThreshold, actualSuccessThreshold);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property tcpSocket so that assertions can be done on it
   */
  public TCPSocketActionAssert tcpSocket()  {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TCPSocketActionAssert) assertThat(actual.getTcpSocket()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tcpSocket"));
  }


  /**
   * Verifies that the actual Probe's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual Probe's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Probe's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Integer timeoutSeconds) {
    // check that actual Probe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
